/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.json.typeadapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.class_3518;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.geckolib.cache.GeckoLibResources;
import software.bernie.geckolib.cache.animation.Animation;
import software.bernie.geckolib.cache.animation.keyframeevent.CustomInstructionKeyframeData;
import software.bernie.geckolib.cache.animation.keyframeevent.KeyFrameData;
import software.bernie.geckolib.cache.animation.keyframeevent.ParticleKeyframeData;
import software.bernie.geckolib.cache.animation.keyframeevent.SoundKeyframeData;

@ApiStatus.Internal
public final class KeyFrameMarkersAdapter {
    public static JsonDeserializer<Animation.KeyframeMarkers> deserializer() throws JsonParseException {
        return KeyFrameMarkersAdapter::fromJson;
    }

    private static Animation.KeyframeMarkers fromJson(JsonElement json, Type type, JsonDeserializationContext context) {
        JsonObject obj = json.getAsJsonObject();
        SoundKeyframeData[] sounds = KeyFrameMarkersAdapter.buildSoundFrameData(obj);
        ParticleKeyframeData[] particles = KeyFrameMarkersAdapter.buildParticleFrameData(obj);
        CustomInstructionKeyframeData[] customInstructions = KeyFrameMarkersAdapter.buildCustomFrameData(obj);
        return new Animation.KeyframeMarkers(sounds, particles, customInstructions);
    }

    private static SoundKeyframeData[] buildSoundFrameData(JsonObject rootObj) {
        JsonObject soundsObj = class_3518.method_15281((JsonObject)rootObj, (String)"sound_effects", (JsonObject)new JsonObject());
        ObjectArrayList sounds = new ObjectArrayList(soundsObj.size());
        for (Map.Entry entry : soundsObj.entrySet()) {
            sounds.add(new SoundKeyframeData(Double.parseDouble((String)entry.getKey()), class_3518.method_15265((JsonObject)((JsonElement)entry.getValue()).getAsJsonObject(), (String)"effect")));
        }
        sounds.sort(Comparator.comparing(KeyFrameData::getTime));
        return sounds.toArray(new SoundKeyframeData[0]);
    }

    private static ParticleKeyframeData[] buildParticleFrameData(JsonObject rootObj) {
        JsonObject particlesObj = class_3518.method_15281((JsonObject)rootObj, (String)"particle_effects", (JsonObject)new JsonObject());
        ObjectArrayList particles = new ObjectArrayList(particlesObj.size());
        for (Map.Entry entry : particlesObj.entrySet()) {
            JsonObject obj = ((JsonElement)entry.getValue()).getAsJsonObject();
            String effect = class_3518.method_15253((JsonObject)obj, (String)"effect", (String)"");
            String locator = class_3518.method_15253((JsonObject)obj, (String)"locator", (String)"");
            String script = class_3518.method_15253((JsonObject)obj, (String)"pre_effect_script", (String)"");
            particles.add(new ParticleKeyframeData(Double.parseDouble((String)entry.getKey()), effect, locator, script));
        }
        particles.sort(Comparator.comparing(KeyFrameData::getTime));
        return particles.toArray(new ParticleKeyframeData[0]);
    }

    private static CustomInstructionKeyframeData[] buildCustomFrameData(JsonObject rootObj) {
        JsonObject customInstructionsObj = class_3518.method_15281((JsonObject)rootObj, (String)"timeline", (JsonObject)new JsonObject());
        ObjectArrayList customInstructions = new ObjectArrayList(customInstructionsObj.size());
        for (Map.Entry entry : customInstructionsObj.entrySet()) {
            String instructions;
            Object v = entry.getValue();
            if (v instanceof JsonArray) {
                JsonArray array = (JsonArray)v;
                instructions = ((ObjectArrayList)GeckoLibResources.GSON.fromJson((JsonElement)array, ObjectArrayList.class)).toString();
            } else {
                v = entry.getValue();
                if (v instanceof JsonPrimitive) {
                    JsonPrimitive primitive = (JsonPrimitive)v;
                    instructions = primitive.getAsString();
                } else {
                    instructions = "";
                }
            }
            customInstructions.add(new CustomInstructionKeyframeData(Double.parseDouble((String)entry.getKey()), instructions));
        }
        customInstructions.sort(Comparator.comparing(KeyFrameData::getTime));
        return customInstructions.toArray(new CustomInstructionKeyframeData[0]);
    }
}

